from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class OnceBitten(Player):
    """
    Cooperates once when the opponent defects, but if they defect twice in a row
    defaults to forgetful grudger for 10 turns defecting.

    Names:

    - Once Bitten: Original name by Holly Marissa
    """

    name = "Once Bitten"
    classifier = {
        "memory_depth": 12,  # Long memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def __init__(self) -> None:
        super().__init__()
        self.mem_length = 10
        self.grudged = False
        self.grudge_memory = 0

    def strategy(self, opponent: Player) -> Action:
        """
        Begins by playing C, then plays D for mem_length rounds if the opponent
        ever plays D twice in a row.
        """
        if self.grudge_memory >= self.mem_length:
            self.grudge_memory = 0
            self.grudged = False

        if len(opponent.history) < 2:
            return C

        if self.grudged:
            self.grudge_memory += 1
            return D
        elif not (C in opponent.history[-2:]):
            self.grudged = True
            return D
        return C